# include <dos.h>
# include <string.h>
# include <stdio.h>
# include <bios.h>
# include <stdlib.h>
# include <conio.h>
# include <mem.h>
# include <dir.h>

# include "simpwin.h"
# include "swskdef.h"
# include "mouse21.h"
# include "fontedit.h"
# include "color.h"

# define MAIN_WIN 1
# define MAIN_MENU 0
# define QUIT_WIN 5
# define DEMO_MENU 1
# define DEMO_WIN 2
# define TUT_WIN 3
# define TUT_MENU 2
# define FUNC_WIN 4
# define FUNC_MENU 3
# define TXT_WIN 6
# define EXE_WIN 7
# define EXE_MENU 4


int mou_switch;
int display_switch = 1;

int main_menu(void);
int quit(void);
int tutor_menu(void);
int function_menu(void);
int demo_menu(void);
int file_screen(char *file_name);
int text_screen(int file_num);
void dual_font(void);
void large_font(void);
void tall_font(void);
void multi_font(void);
int execute_menu(void);

void main(void)
{
	int i,j,k;

	if(init_window(10,5,5,"",1) != 0)
	{
		cprintf("Can't init simple windows!");
		exit(1);
	}
	system("cls");
	if(mouinstalled() != 0)
	{
		simp_window(30,10,50,12,1,0,14,4,0,0,0,0,0);
		if(loadcurs("cursor.fnt",0) == 0)
		{
			mouhide();
			mousetposition(1,1);
			mou_switch = 1;
			write_window(3,2,"Mouse Installed !");
		}
		else
		{
			mou_switch = 0;
			write_window(3,2,"No cursor file !");
		}
		delay(1000);
	}
	else
	{
		simp_window(23,10,57,12,1,0,14,4,0,0,0,0,0);
		write_window(3,2,"NO mouse driver installed");
		mou_switch = 0;
		delay(1000);
	}
	if(load_menu_text("fonttut.men") != 0)
	{
		cprintf("Can't find file FONTEDIT.MEN !");
		uninit_window();
		remove("temp.pal");
		exit(1);
	}
	if(load_win_data("fonttut.win") != 0)
	{
		cprintf("Can't find file FONTEDIT.WIN !");
		uninit_window();
		remove("temp.pal");
		exit(1);
	}
	hide_cursor();
	set_palette(MAGENTA,C_DARK_GRAY_2);
	set_palette(BROWN,C_WHITE);
	set_palette(GREEN,C_YELLOW);
	set_palette(LIGHTBLUE,C_BLACK);
	k= 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			simp_window(40 - j,13 - i,40 + j,13 + i,1,0,6,1,0,0,0,0,0);
		}
		k = k + 3;
	}
	simp_window(1,1,80,25,1,0,6,1,0,0,0,0,0);
	k = 3;
	for(i = 0;i < 13;i++)
	{
		for(j = k - 3;j < k;j++)
		{
			window(40 - j,13 - i,40 + j,13 + i);
			load_screen_form(0,"fonttut.scr");
		}
		k = k + 3;
	}
	window(1,1,80,25);
	load_screen_form(0,"fonttut.scr");
	write_window(35,25," HIT ANY KEY ");
	bioskey(0);
	draw_horizontal_line(196,196,196,2,79,25);
	save_screen(1);
	moucursortype(0x00ff);
	moushow();
	while(main_menu())
	{
	}
	uninit_window();
	show_cursor();
	set_palette(MAGENTA,C_MAGENTA);
	set_palette(BROWN,C_BROWN);
	set_palette(GREEN,C_GREEN);
	set_palette(LIGHTBLUE,C_BLUE_3);
	system("cls");
}

int main_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][13] = {"Demo","Tutor","eXit"};


	if(display_switch)
	{
		load_screen(1);
		call_window(MAIN_WIN);
		call_menu(MAIN_MENU,3,2);
		save_screen(2);
	}
	else
	{
		load_screen(2);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"D");
	write_window(22,2,"T");
	write_window(41,2,"X");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if(mousey == 4)
			{
				if((mousex > 5) & (mousex < 12))
				{
					i = 0;
				}
				else if((mousex > 24) & (mousex < 31))
				{
					i = 1;
				}
				else if((mousex > 42) & (mousex < 49))
				{
					i = 2;
				}
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			mouhide();
			old_i = i;
			load_screen_buff();
			switch(i)
			{
				case 0 : simp_window(6,4,11,4,0,2,4,3,1,5,0,0,0); break;
				case 1 : simp_window(25,4,31,4,0,2,4,3,1,5,0,0,0); break;
				case 2 : simp_window(43,4,48,4,0,2,4,3,1,5,0,0,0); break;
			}
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 4; break;
				case CURSOR_RIGHT : i = i + 1; break;
				case CURSOR_LEFT : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_T : choice = 3; break;
				case ALT_X : choice = 4; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if(mousey == 4)
			{
				if(((mousex > 5) & (mousex < 12)) |
					((mousex > 24) & (mousex < 31)) |
					((mousex > 42) & (mousex < 49)))
				{
					choice = 1;
				}
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	if(choice == 1)
	{
		choice = i + 2;
	}
	pick = 1;
	switch(choice)
	{
		case 2 : while(demo_menu()){} break;
		case 3 : while(tutor_menu()){} break;
		case 4 : pick = quit(); break;
	}
	return(pick);
}

int quit(void)
{

	call_window(QUIT_WIN);
	write_window(3,2,"Quit Y/N ?");
	show_cursor();
	if(get_choice(14,2,"N") == 1)
	{
		uncall_window(QUIT_WIN);
		hide_cursor();
		return(0);
	}
	uncall_window(QUIT_WIN);
	hide_cursor();
	return(1);
}


int demo_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[3][17] = {"Dual demo","Large demo","Multi demo"};

	if(display_switch)
	{
		load_screen(2);
		call_window(DEMO_WIN);
		call_menu(DEMO_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"D");
	write_window(3,3,"L");
	write_window(3,4,"M");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 7) & (mousex < 19))
			{
				i = mousey - 5;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 2)
		{
			i = 2;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(7,5 + i,25,5 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_D : choice = 2; break;
				case ALT_L : choice = 3; break;
				case ALT_M : choice = 4; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 7) & (mousex < 19) & (mousey > 4) & (mousey < 8))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : dual_font(); break;
		case 3 : large_font(); break;
		case 4 : multi_font(); break;
		case 9 : pick = 0; break;
	}
	display_switch = 0;
	return(pick);
}


int tutor_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[5][19] = {"General","Support","Functions","Executes","A word"};

	if(display_switch)
	{
		if(display_switch == 1)
		{
			load_screen(2);
		}
		call_window(TUT_WIN);
		call_menu(TUT_MENU,3,2);
		save_screen(3);
	}
	else
	{
		load_screen(3);
	}
	display_switch = 1;
	textcolor(4);
	write_window(3,2,"G");
	write_window(3,3,"S");
	write_window(3,4,"F");
	write_window(3,5,"E");
	write_window(3,6,"A");
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 20) & (mousex < 30))
			{
				i = mousey - 5;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 4)
		{
			i = 4;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(21,5 + i,31,5 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 7; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER : choice = 1; break;
				case ALT_G : choice = 2; break;
				case ALT_S : choice = 3; break;
				case ALT_F : choice = 4; break;
				case ALT_A : choice = 6; break;
				case ALT_E : choice = 5; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 20) & (mousex < 30) & (mousey > 4) & (mousey < 10))
			{
				choice = 1;
			}
			else
			{
				choice = 7;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		choice = i + 2;
	}
	switch(choice)
	{
		case 2 : file_screen("general.txt"); break;
		case 3 : text_screen(5); break;
		case 4 : while(function_menu()){} break;
		case 5 : while(execute_menu()){} break;
		case 6 : text_screen(6);
		case 7 : pick = 0; break;
	}
	display_switch = pick;
	return(pick);
}

int function_menu(void)
{
	int pick,choice,i = 0,old_i = 12,mousex = 0,mousey = 0;
	char lable[11][29] = {"load_font\(\)","enable_dual_font\(\)","write_win_bank\(\)",
				"write_win_multi\(\)","load_emulate\(\)","write_win_large\(\)",
				"write_win_multi_large\(\)","set_palette\(\)",
				"font_get_adapter\(\)","toggle_blink\(\)",
				"toggle_intensity\(\)"};

	if(display_switch)
	{
		load_screen(3);
		call_window(FUNC_WIN);
		call_menu(FUNC_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	save_screen_buff();
	moushow();
	i = 0;
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 46))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 10)
		{
			i = 10;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,6 + i,47,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 12; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 46) & (mousey > 5) & (mousey < 17))
			{
				choice = 1;
			}
			else
			{
				choice = 12;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		text_screen(i + 7);
	}
	else
	{
		if(choice == 12)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}

int execute_menu(void)
{
	int pick,choice,i = 0,old_i = 9,mousex = 0,mousey = 0;
	char lable[4][29] = {"loadfont.exe","dualon.exe","setpal.exe","makefont.exe"};

	if(display_switch)
	{
		load_screen(3);
		call_window(EXE_WIN);
		call_menu(EXE_MENU,3,2);
		save_screen(4);
	}
	else
	{
		load_screen(4);
	}
	display_switch = 1;
	save_screen_buff();
	i = 0;
	moushow();
	for(;;)
	{
		choice = 0;
		if(mouposition(&mousex,&mousey))
		{
			if((mousex > 22) & (mousex < 46))
			{
				i = mousey - 6;
			}
		}
		if(i < 0)
		{
			i = 0;
		}
		if(i > 3)
		{
			i = 3;
		}
		if(old_i != i)
		{
			old_i = i;
			mouhide();
			load_screen_buff();
			simp_window(23,6 + i,41,6 + i,0,2,4,3,1,5,0,0,0);
			write_window(2,1,"%s",lable[i]);
			moushow();
		}
		if(bioskey(1) | (mou_switch == 0))
		{
			switch(bioskey(0))
			{
				case ESC : choice = 9; break;
				case CURSOR_DN : i = i + 1; break;
				case CURSOR_UP : i = i - 1; break;
				case ENTER: choice = 1; break;
			}
		}
		if(moubuttonpressed(LEFTBUTTON))
		{
			if((mousex > 22) & (mousex < 46) & (mousey > 5) & (mousey < 10))
			{
				choice = 1;
			}
			else
			{
				choice = 9;
			}
		}
		if(choice != 0)
		{
			break;
		}
	}
	mouhide();
	load_screen_buff();
	pick = 1;
	if(choice == 1)
	{
		text_screen(i + 18);
	}
	else
	{
		if(choice == 9)
		{
			pick = 0;
		}
	}
	display_switch = 0;
	return(pick);
}


int text_screen(int file_num)
{
	call_window(TXT_WIN);
	load_text(file_num,"fonttut.men");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TXT_WIN);
	return(0);
}

int file_screen(char *file_name)
{
	call_window(TXT_WIN);
	write_window((80 - strlen(" PgUp/PgDn ESC ")) / 2,25," PgUp/PgDn ESC ");
	read_text(file_name,1);
	uncall_window(TXT_WIN);
	return(0);
}

void dual_font(void)
{
	call_window(TXT_WIN);
	enable_double_font(1);
	load_font("script.fnt",1);
	hide_cursor();
	write_win_bank(0,3,4,"This is the low bank font called by write_win_bank\(\)");
	write_win_bank(1,3,5,"This is the high bank font called by write_win_bank\(\)");
	write_win_bank(0,3,7,"You can use this for ");
	write_win_bank(1,24,7,"Highlight");
	write_win_bank(0,34,7,"like this");
	write_win_bank(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TXT_WIN);
	enable_double_font(0);
	hide_cursor();
}

void large_font(void)
{
	call_window(TXT_WIN);
	enable_double_font(1);
	load_font("script.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_large(0,3,3,"Low Bank Font.");
	write_win_large(1,3,13,"High Bank font.");
	write_window((80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TXT_WIN);
	enable_double_font(0);
	hide_cursor();
}


void multi_font(void)
{
	call_window(TXT_WIN);
	enable_double_font(1);
	load_font("fdemo1.fnt",0);
	load_font("fdemo2.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_multi(1,3,3,"This is font 1 from lower bank");
	write_win_multi(2,3,4,"This is font 2 from lower bank");
	write_win_multi(3,3,5,"This is font 3 from high bank");
	write_win_multi(4,3,6,"This is font 4 from high bank");
	write_win_multi_large(1,3,7,"FONT 1");
	write_win_multi_large(2,40,7,"FONT 2");
	write_win_multi_large(3,3,16,"FONT 3");
	write_win_multi_large(4,40,16,"FONT 4");
	write_win_multi(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	clear_window(0);
	load_font("fdemo.fnt",1);
	load_emulate(1);
	hide_cursor();
	write_win_multi(1,3,3,"Some stuff you can do");
	write_win_multi_large(3,29,5,"D");
	write_win_multi_large(3,25,13,"ACB");
	write_win_multi(3,40,5,"D");
	write_win_multi(3,39,6,"ACB");
	write_win_multi(1,(80 - strlen(" HIT ANY KEY ")) / 2,25," HIT ANY KEY ");
	bioskey(0);
	uncall_window(TXT_WIN);
	enable_double_font(0);
	load_font("ibmstd.fnt",0);
	hide_cursor();
}

